
import gurobipy as gp

# Create a new model
model = gp.Model("PaintMixing")

# Create variables
ruby = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ruby") # cans of Ruby paint
sapphire = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="sapphire") # cans of Sapphire paint


# Set objective function
model.setObjective(12*ruby + 15*sapphire, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(2*ruby + 4*sapphire >= 15, "dye_constraint")
model.addConstr(4*ruby + 6*sapphire >= 20, "thinner_constraint")
model.addConstr(5*ruby + 2*sapphire >= 18, "water_constraint")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Minimum cost: ${model.objVal}")
    print(f"Number of Ruby cans: {ruby.x}")
    print(f"Number of Sapphire cans: {sapphire.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

