
from gurobipy import *

# Create a new model
m = Model("Paint_Mixture")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="Ruby_Paint")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="Sapphire_Paint")

# Set the objective function
m.setObjective(12*x1 + 15*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 4*x2 >= 15, "Dye_Requirement")
m.addConstr(4*x1 + 6*x2 >= 20, "Thinner_Requirement")
m.addConstr(5*x1 + 2*x2 >= 18, "Water_Requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of cans of Ruby paint: {x1.x}")
    print(f"Number of cans of Sapphire paint: {x2.x}")
    print(f"Total cost: ${12*x1.x + 15*x2.x:.2f}")
else:
    print("No optimal solution found")
