
import gurobi

def solve_paint_mixture_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='x1', lb=0, vtype=gurobi.GRB.CONTINUOUS)  # cans of Ruby paint
    x2 = model.addVar(name='x2', lb=0, vtype=gurobi.GRB.CONTINUOUS)  # cans of Sapphire paint

    # Objective function: minimize 12*x1 + 15*x2
    model.setObjective(12*x1 + 15*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2*x1 + 4*x2 >= 15, name='dye_constraint')
    model.addConstr(4*x1 + 6*x2 >= 20, name='thinner_constraint')
    model.addConstr(5*x1 + 2*x2 >= 18, name='water_constraint')

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("No optimal solution found")

solve_paint_mixture_problem()
