
import gurobipy as gp

# Create a new model
model = gp.Model("Donut Optimization")

# Create variables
regular_donuts = model.addVar(vtype=gp.GRB.INTEGER, name="regular_donuts")
jelly_donuts = model.addVar(vtype=gp.GRB.INTEGER, name="jelly_donuts")


# Set objective function
model.setObjective(2 * regular_donuts + 3 * jelly_donuts, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(regular_donuts + jelly_donuts <= 1000, "Demand Constraint")
model.addConstr(4 * regular_donuts + 6 * jelly_donuts <= 5000, "Budget Constraint")
model.addConstr(regular_donuts >= 0, "Non-negativity Constraint 1")
model.addConstr(jelly_donuts >= 0, "Non-negativity Constraint 2")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of regular donuts: {regular_donuts.x}")
    print(f"Number of jelly-filled donuts: {jelly_donuts.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

