
from gurobipy import *

# Create a new model
m = Model("donut_optimization")

# Add variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="regular_donuts")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="jelly_filled_donuts")

# Set the objective function
m.setObjective(2*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 1000, "total_donuts")
m.addConstr(4*x1 + 6*x2 <= 5000, "budget")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular donuts: {x1.x}")
    print(f"Jelly-filled donuts: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
