
import gurobipy as gp

# Create a new model
model = gp.Model("Donut_Optimization")

# Define variables
x1 = model.addVar(name="regular_donuts", lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="jelly_filled_donuts", lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS)

# Objective function: Maximize 2*x1 + 3*x2
model.setObjective(2*x1 + 3*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(4*x1 + 6*x2 <= 5000, name="Cost_Constraint")
model.addConstr(x1 + x2 <= 1000, name="Donut_Sales_Constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Number of regular donuts: {x1.varValue}")
    print(f"Number of jelly-filled donuts: {x2.varValue}")
    print(f"Maximum Profit: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
