
import gurobipy as gp

# Create a new model
m = gp.Model("BakeryOptimization")

# Create variables
pancakes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="pancakes")
bagels = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bagels")

# Set objective function
m.setObjective(25 * pancakes + 30 * bagels, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(25 * pancakes + 9 * bagels <= 150, "Daniel's Time")
m.addConstr(15 * pancakes + 20 * bagels <= 350, "David's Time")
m.addConstr(pancakes >= 0, "Non-negative pancakes")  # Explicit non-negativity constraints
m.addConstr(bagels >= 0, "Non-negative bagels")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of pancake batches: {pancakes.x}")
    print(f"Number of bagel batches: {bagels.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

