
from gurobipy import *

# Create a new model
m = Model("Bakery_Optimization")

# Define the variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="batches_of_pancakes", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="batches_of_bagels", lb=0)

# Set the objective function
m.setObjective(25*x1 + 30*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(25*x1 + 9*x2 <= 150, "Daniel's_time")
m.addConstr(15*x1 + 20*x2 <= 350, "David's_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
