
import gurobi

def solve_bakery_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="pancakes", lb=0, vtype=gurobi.GRB.INTEGER)  # batches of pancakes
    x2 = model.addVar(name="bagels", lb=0, vtype=gurobi.GRB.INTEGER)  # batches of bagels

    # Objective function: Maximize profit
    model.setObjective(25 * x1 + 30 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(25 * x1 + 9 * x2 <= 150, name="daniel_time")
    model.addConstr(15 * x1 + 20 * x2 <= 350, name="david_time")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal batches of pancakes: {x1.varValue}")
        print(f"Optimal batches of bagels: {x2.varValue}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_bakery_problem()
