
from gurobipy import *

# Create a new model
m = Model("Smoothie_Optimization")

# Define variables
x1 = m.addVar(name="peanut_butter_smoothies", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="almond_butter_smoothies", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(3*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 <= 80, name="peanut_butter_availability")
m.addConstr(3*x2 <= 90, name="almond_butter_availability")
m.addConstr(3*x1 + 3*x2 <= 100, name="milk_availability")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of peanut butter smoothies: {x1.x}")
    print(f"Number of almond butter smoothies: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
