
import gurobi

def solve_smoothie_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="peanut_butter_smoothies", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="almond_butter_smoothies", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: Maximize 3*x1 + 5*x2
    model.setObjective(3*x1 + 5*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2*x1 <= 80, name="peanut_butter_constraint")
    model.addConstr(3*x2 <= 90, name="almond_butter_constraint")
    model.addConstr(3*x1 + 3*x2 <= 100, name="milk_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found")

solve_smoothie_problem()
