
import gurobipy as gp

# Create a new model
m = gp.Model("BobsDiet")

# Create variables
chicken = m.addVar(lb=0, name="chicken")
pork = m.addVar(lb=0, name="pork")

# Set objective function
m.setObjective(10 * chicken + 15 * pork, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(20 * chicken + 15 * pork >= 100, "protein_req")
m.addConstr(5 * chicken + 3 * pork >= 50, "carb_req")
m.addConstr(6 * chicken + 8 * pork >= 30, "fat_req")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: {m.objVal}")
    print(f"Chicken servings: {chicken.x}")
    print(f"Pork servings: {pork.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

