
from gurobipy import *

# Create a new model
m = Model("Bob's Diet")

# Create variables
x1 = m.addVar(name='servings_of_chicken', vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name='servings_of_pork', vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(10*x1 + 15*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(20*x1 + 15*x2 >= 100, name='protein_requirement')
m.addConstr(5*x1 + 3*x2 >= 50, name='carbs_requirement')
m.addConstr(6*x1 + 8*x2 >= 30, name='fat_requirement')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Servings of chicken: {x1.x}")
    print(f"Servings of pork: {x2.x}")
    print(f"Total cost: ${10*x1.x + 15*x2.x:.2f}")
else:
    print("No optimal solution found")
