
import gurobipy as gp

# Create a new model
model = gp.Model("Bob's Nutrition Problem")

# Define the variables
x1 = model.addVar(name="chicken", lb=0)  # servings of chicken
x2 = model.addVar(name="pork", lb=0)    # servings of pork

# Define the objective function
model.setObjective(10*x1 + 15*x2, gp.GRB.MINIMIZE)

# Define the constraints
model.addConstr(20*x1 + 15*x2 >= 100, name="protein")
model.addConstr(5*x1 + 3*x2 >= 50, name="carbs")
model.addConstr(6*x1 + 8*x2 >= 30, name="fat")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Servings of chicken: {x1.varValue}")
    print(f"Servings of pork: {x2.varValue}")
    print(f"Total cost: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
