
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("math_contest")

# Create variables
algebra = m.addVar(vtype=GRB.INTEGER, name="algebra")
calculus = m.addVar(vtype=GRB.INTEGER, name="calculus")

# Set objective function
m.setObjective(algebra + 3 * calculus, GRB.MAXIMIZE)

# Add constraints
m.addConstr(algebra + calculus <= 25, "total_questions")
m.addConstr(algebra >= 10, "min_algebra")
m.addConstr(calculus >= 6, "min_calculus")
m.addConstr(algebra <= 15, "max_algebra")
m.addConstr(calculus <= 15, "max_calculus")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal score: {m.objVal}")
    print(f"Number of algebra questions: {algebra.x}")
    print(f"Number of calculus questions: {calculus.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

