
from gurobipy import *

# Create a new model
m = Model("Math_Contest")

# Add variables
x1 = m.addVar(lb=10, ub=15, vtype=GRB.INTEGER, name="algebra_questions")
x2 = m.addVar(lb=6, ub=15, vtype=GRB.INTEGER, name="calculus_questions")

# Set the objective function
m.setObjective(x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 25, "total_questions")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Algebra questions: {x1.x}")
    print(f"Calculus questions: {x2.x}")
    print(f"Maximum score: {m.objVal}")
else:
    print("No optimal solution found")
