
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, ub=15, vtype=gurobi.GRB.INTEGER, name="algebra_questions")
    x2 = model.addVar(lb=0, ub=15, vtype=gurobi.GRB.INTEGER, name="calculus_questions")

    # Objective function: Maximize 1*x1 + 3*x2
    model.setObjective(1*x1 + 3*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 25, name="total_questions")
    model.addConstr(x1 >= 10, name="min_algebra")
    model.addConstr(x2 >= 6, name="min_calculus")
    model.addConstr(x1 <= 15, name="max_algebra")
    model.addConstr(x2 <= 15, name="max_calculus")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Algebra questions = {x1.varValue}, Calculus questions = {x2.varValue}")
        print(f"Maximum Score: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
