
import gurobipy as gp

# Create a new model
model = gp.Model("Paper Production")

# Create variables
dotted_paper = model.addVar(vtype=gp.GRB.CONTINUOUS, name="dotted_paper")  # x1
grid_paper = model.addVar(vtype=gp.GRB.CONTINUOUS, name="grid_paper")  # x2

# Set objective function
model.setObjective(5.5 * dotted_paper + 11 * grid_paper, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * dotted_paper + 1.5 * grid_paper <= 3000, "Cutting Machine Constraint")
model.addConstr(5.5 * dotted_paper + 7 * grid_paper <= 3000, "Printing Machine Constraint")
model.addConstr(dotted_paper >= 0, "Dotted Paper Non-Negativity")
model.addConstr(grid_paper >= 0, "Grid Paper Non-Negativity")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found. Profit: ${model.objVal:.2f}")
    print(f"Dotted Paper: {dotted_paper.x:.2f} reams")
    print(f"Grid Paper: {grid_paper.x:.2f} reams")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

