
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="dotted_paper", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="grid_paper", lb=0, ub=gurobi.GRB.INFINITY)

    # Define objective function
    model.setObjective(5.5 * x1 + 11 * x2, gurobi.GRB.MAXIMIZE)

    # Define constraints
    model.addConstr(3 * x1 + 1.5 * x2 <= 3000, name="cutting_machine_constraint")
    model.addConstr(5.5 * x1 + 7 * x2 <= 3000, name="printing_machine_constraint")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found")

solve_optimization_problem()
