
import gurobipy as gp

# Create a new model
model = gp.Model("Lightbulb_Production")

# Create decision variables
led = model.addVar(vtype=gp.GRB.CONTINUOUS, name="led")  # Packages of LED lightbulbs
halogen = model.addVar(vtype=gp.GRB.CONTINUOUS, name="halogen")  # Packages of Halogen lightbulbs

# Set objective function
model.setObjective(30 * led + 50 * halogen, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(6 * led + 9 * halogen <= 500, "plastics_constraint")
model.addConstr(12 * led + 10 * halogen <= 500, "wiring_constraint")
model.addConstr(led >= 0, "non_negativity_led")  # Ensure non-negative production
model.addConstr(halogen >= 0, "non_negativity_halogen")


# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of LED packages: {led.x}")
    print(f"Number of Halogen packages: {halogen.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

