
from gurobipy import *

# Create a model
m = Model("Lightbulb_Production")

# Define variables
x1 = m.addVar(name="LED", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="Halogen", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(30*x1 + 50*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x1 + 9*x2 <= 500, name="Plastics_Machine")
m.addConstr(12*x1 + 10*x2 <= 500, name="Wiring_Machine")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print("Objective:", m.objVal)
