
import gurobipy as gp

# Create a new model
model = gp.Model("Lighting_Company_Optimization")

# Define the variables
x1 = model.addVar(name="LED_packages", lb=0)  # packages of LED lightbulbs
x2 = model.addVar(name="Halogen_packages", lb=0)  # packages of Halogen lightbulbs

# Define the objective function
model.setObjective(30*x1 + 50*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(6*x1 + 9*x2 <= 500, name="plastics_machine_constraint")
model.addConstr(12*x1 + 10*x2 <= 500, name="wiring_machine_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: LED_packages = {x1.varValue}, Halogen_packages = {x2.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
