
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("restaurant_optimization")

# Create variables
breakfast = m.addVar(vtype=GRB.CONTINUOUS, name="breakfast")  # Number of breakfast options
lunch = m.addVar(vtype=GRB.CONTINUOUS, name="lunch")  # Number of lunch options


# Set objective function
m.setObjective(10 * breakfast + 8 * lunch, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * breakfast + 8 * lunch <= 700, "prep_time")  # Preparation time constraint
m.addConstr(2 * breakfast + 3 * lunch <= 500, "packaging_time")  # Packaging time constraint
m.addConstr(breakfast >= 0, "breakfast_nonnegative")
m.addConstr(lunch >= 0, "lunch_nonnegative")



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of breakfast options: {breakfast.x:.2f}")
    print(f"Number of lunch options: {lunch.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

