
from gurobipy import *

# Create a new model
m = Model("Meal_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="breakfast_options")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="lunch_options")

# Set the objective function
m.setObjective(10*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x1 + 8*x2 <= 700, "preparation_time")
m.addConstr(2*x1 + 3*x2 <= 500, "packaging_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of breakfast options: {x1.x}")
    print(f"Number of lunch options: {x2.x}")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("No optimal solution found")
