
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="breakfast_option")
    x2 = model.addVar(lb=0, name="lunch_option")

    # Objective function
    model.setObjective(10*x1 + 8*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(7*x1 + 8*x2 <= 700, name="preparation_time_constraint")
    model.addConstr(2*x1 + 3*x2 <= 500, name="packaging_time_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found")

solve_optimization_problem()
