
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("movie_investment")

# Create variables
action_movie = m.addVar(lb=0, name="action_movie")
animation_movie = m.addVar(lb=0, name="animation_movie")

# Set objective function
m.setObjective(0.09 * action_movie + 0.06 * animation_movie, GRB.MAXIMIZE)

# Add constraints
m.addConstr(action_movie + animation_movie <= 500000, "total_investment")
m.addConstr(animation_movie >= 3 * action_movie, "animation_investment_ratio")
m.addConstr(animation_movie <= 400000, "max_animation_investment")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Invest ${action_movie.x:.2f} in the action movie.")
    print(f"Invest ${animation_movie.x:.2f} in the animation movie.")
    print(f"Total earnings: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

