
from gurobipy import *

# Create a new model
m = Model("Movie_Investment")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Action_Movie")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Animation_Movie")

# Set the objective function
m.setObjective(0.09*x1 + 0.06*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 == 500000, "Total_Investment")
m.addConstr(x2 >= 3*x1, "Animation_VS_Action")
m.addConstr(x2 <= 400000, "Max_Animation")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Action Movie Investment: ${x1.x:.2f}")
    print(f"Animation Movie Investment: ${x2.x:.2f}")
    print(f"Total Earnings: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
