
import gurobi

def solve_movie_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="action_movie_investment", lb=0)
    x2 = model.addVar(name="animation_movie_investment", lb=0)

    # Objective function: maximize 0.09*x1 + 0.06*x2
    model.setObjective(0.09 * x1 + 0.06 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 500000, name="total_investment")
    model.addConstr(x2 >= 3 * x1, name="animation_vs_action")
    model.addConstr(x2 <= 400000, name="animation_limit")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in action movie: ${x1.varValue:.2f}")
        print(f"Optimal investment in animation movie: ${x2.varValue:.2f}")
        print(f"Maximized earnings: ${0.09 * x1.varValue + 0.06 * x2.varValue:.2f}")
    else:
        print("The model is infeasible.")

solve_movie_investment_problem()
