
import gurobipy as gp

# Create a new model
m = gp.Model("Investment_Problem")

# Create variables
solar_investment = m.addVar(name="solar_investment")
wind_investment = m.addVar(name="wind_investment")

# Set objective function
m.setObjective(0.10 * solar_investment + 0.09 * wind_investment, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(solar_investment + wind_investment <= 6000, "Total_Investment")
m.addConstr(solar_investment >= 0.45 * (solar_investment + wind_investment), "Solar_Investment_Minimum_Percentage")
m.addConstr(wind_investment >= 3000, "Wind_Investment_Minimum")
m.addConstr(solar_investment >=0, "NonNegative_Solar")
m.addConstr(wind_investment >=0, "NonNegative_Wind")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Invest ${solar_investment.x:.2f} in solar energy")
    print(f"Invest ${wind_investment.x:.2f} in wind energy")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

