
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define variables
x1 = m.addVar(lb=2700, name="solar_energy_investment")
x2 = m.addVar(lb=3000, name="wind_energy_investment")

# Set the objective function
m.setObjective(0.10*x1 + 0.09*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 == 6000, name="total_investment")
m.update()

# Solve the model
m.optimize()

# Print the solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
