
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="solar_investment", lb=0)
    x2 = model.addVar(name="wind_investment", lb=0)

    # Objective function: maximize 0.10*x1 + 0.09*x2
    model.setObjective(0.10 * x1 + 0.09 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 6000, name="total_investment")
    model.addConstr(0.55 * x1 - 0.45 * x2 >= 0, name="solar_minimum")
    model.addConstr(x2 >= 3000, name="wind_minimum")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal investment in solar energy company: ", x1.varValue)
        print("Optimal investment in wind energy company: ", x2.varValue)
        print("Maximum profit: ", model.objVal)
    else:
        print("The model is infeasible")

solve_investment_problem()
