
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("clothing_optimization")

# Create variables
coats = m.addVar(vtype=GRB.CONTINUOUS, name="coats")
shirts = m.addVar(vtype=GRB.CONTINUOUS, name="shirts")

# Set objective function
m.setObjective(6 * coats + 11 * shirts, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.7 * coats + 0.2 * shirts <= 50, "measuring_constraint")
m.addConstr(0.5 * coats + 0.3 * shirts <= 35, "cutting_constraint")
m.addConstr(0.9 * coats + 0.5 * shirts <= 40, "sewing_constraint")
m.addConstr(coats >= 0, "coats_nonnegative")
m.addConstr(shirts >= 0, "shirts_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Coats to Make: {coats.x}")
    print(f"Number of Shirts to Make: {shirts.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

