
from gurobipy import *

# Create a new model
m = Model("Clothing_Company_Profit")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="coats", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="shirts", lb=0)

# Set the objective function
m.setObjective(6*x1 + 11*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.7*x1 + 0.2*x2 <= 50, "measuring_team")
m.addConstr(0.5*x1 + 0.3*x2 <= 35, "cutting_team")
m.addConstr(0.9*x1 + 0.5*x2 <= 40, "sewing_team")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of coats: {x1.x}")
    print(f"Number of shirts: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found.")

