
import gurobipy as gp

# Create a new model
m = gp.Model("Clothing_Company")

# Define variables
x1 = m.addVar(name="coats", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = m.addVar(name="shirts", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define objective function
m.setObjective(6*x1 + 11*x2, gp.GRB.MAXIMIZE)

# Define constraints
m.addConstr(0.7*x1 + 0.2*x2 <= 50, name="measuring_team")
m.addConstr(0.5*x1 + 0.3*x2 <= 35, name="cutting_team")
m.addConstr(0.9*x1 + 0.5*x2 <= 40, name="sewing_team")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of coats: {x1.varValue}")
    print(f"Number of shirts: {x2.varValue}")
    print(f"Max profit: {m.objVal}")
else:
    print("No optimal solution found.")
