
import gurobipy as gp

# Create a new model
m = gp.Model("Investment_Portfolio")

# Create variables
oil_gas = m.addVar(lb=0, name="oil_gas")
tech = m.addVar(lb=0, name="tech")
mining = m.addVar(lb=0, name="mining")
retail = m.addVar(lb=0, name="retail")

# Set objective function
m.setObjective(0.06 * oil_gas + 0.08 * tech + 0.09 * mining + 0.11 * retail, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(oil_gas + tech + mining + retail <= 1000000, "Total_Investment")
m.addConstr(retail <= oil_gas, "Retail_OilGas")
m.addConstr(tech <= mining, "Tech_Mining")
m.addConstr(retail <= 0.28 * (oil_gas + tech + mining + retail), "Retail_Total")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal return: ${m.objVal:.2f}")
    print(f"Invest in Oil and Gas: ${oil_gas.x:.2f}")
    print(f"Invest in Tech: ${tech.x:.2f}")
    print(f"Invest in Mining: ${mining.x:.2f}")
    print(f"Invest in Retail: ${retail.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

