
from gurobipy import *

# Create a new model
m = Model("George_Investment")

# Define the variables
x1 = m.addVar(name="oil_and_gas", lb=0)
x2 = m.addVar(name="tech", lb=0)
x3 = m.addVar(name="mining", lb=0)
x4 = m.addVar(name="retail", lb=0)

# Set the objective function
m.setObjective(0.06*x1 + 0.08*x2 + 0.09*x3 + 0.11*x4, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 + x3 + x4 <= 1000000, name="total_investment")
m.addConstr(x4 <= x1, name="retail_vs_oil_gas")
m.addConstr(x2 <= x3, name="tech_vs_mining")
m.addConstr(x4 <= 0.28*(x1 + x2 + x3 + x4), name="max_retail_percentage")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Oil and Gas: {x1.x}")
    print(f"Tech: {x2.x}")
    print(f"Mining: {x3.x}")
    print(f"Retail: {x4.x}")
    print(f"Total Return: {m.objVal}")
else:
    print("No optimal solution found")
