
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="oil_and_gas", lb=0)
    x2 = model.addVar(name="tech", lb=0)
    x3 = model.addVar(name="mining", lb=0)
    x4 = model.addVar(name="retail", lb=0)

    # Objective function
    model.setObjective(0.06 * x1 + 0.08 * x2 + 0.09 * x3 + 0.11 * x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 + x3 + x4 <= 1000000)
    model.addConstr(x4 <= x1)
    model.addConstr(x2 <= x3)
    model.addConstr(x4 <= 280000)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Oil and Gas: {x1.varValue}")
        print(f"Tech: {x2.varValue}")
        print(f"Mining: {x3.varValue}")
        print(f"Retail: {x4.varValue}")
        print(f"Max Return: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
