
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
daikons = m.addVar(lb=0, name="daikons")  # Acres of daikons
fennels = m.addVar(lb=0, name="fennels")  # Acres of fennels

# Set objective function: Maximize revenue
m.setObjective(300 * daikons + 250 * fennels, GRB.MAXIMIZE)

# Add constraints
m.addConstr(daikons + fennels <= 300, "land_constraint")  # Land constraint
m.addConstr(0.5 * daikons + 1.5 * fennels <= 500, "watering_constraint")  # Watering constraint
m.addConstr(70 * daikons + 50 * fennels <= 7400, "compost_constraint")  # Compost constraint


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print(f"Optimal revenue: ${m.objVal:.2f}")
    print(f"Acres of daikons: {daikons.x:.2f}")
    print(f"Acres of fennels: {fennels.x:.2f}")

