
import gurobi

def solve_organic_farming_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="daikons")
    x2 = model.addVar(lb=0, name="fennels")

    # Set the objective function
    model.setObjective(300*x1 + 250*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 + x2 <= 300, name="land_constraint")
    model.addConstr(0.5*x1 + 1.5*x2 <= 500, name="watering_constraint")
    model.addConstr(70*x1 + 50*x2 <= 7400, name="compost_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Acres of daikons: {x1.varValue}")
        print(f"Acres of fennels: {x2.varValue}")
        print(f"Max Revenue: {model.objVal}")
    else:
        print("The problem is infeasible")

solve_organic_farming_problem()
