
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("vitamin_mix")

# Create variables
carrot_juice = m.addVar(lb=0, name="carrot_juice")  # Servings of carrot juice
lemon_juice = m.addVar(lb=0, name="lemon_juice")  # Servings of lemon juice

# Set objective function: Minimize cost
m.setObjective(3.5 * carrot_juice + 6 * lemon_juice, GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * carrot_juice + 3 * lemon_juice >= 25, "vitamin_A")  # Vitamin A constraint
m.addConstr(3 * carrot_juice + 6 * lemon_juice >= 25, "vitamin_B")  # Vitamin B constraint


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Servings of carrot juice: {carrot_juice.x:.2f}")
    print(f"Servings of lemon juice: {lemon_juice.x:.2f}")

