
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="carrot_juice")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="lemon_juice")

# Set objective function
m.setObjective(3.5*x1 + 6*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(8*x1 + 3*x2 >= 25, "Vitamin_A_Requirement")
m.addConstr(3*x1 + 6*x2 >= 25, "Vitamin_B_Requirement")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Carrot juice servings: {x1.x}")
    print(f"Lemon juice servings: {x2.x}")
    print(f"Total cost: ${3.5*x1.x + 6*x2.x:.2f}")
else:
    print("No optimal solution found")
