
import gurobipy as gp

# Create a new model
model = gp.Model("Vitamin_Optimization")

# Define the variables
x1 = model.addVar(name="carrot_juice", lb=0)
x2 = model.addVar(name="lemon_juice", lb=0)

# Define the objective function
model.setObjective(3.5 * x1 + 6 * x2, gp.GRB.MINIMIZE)

# Define the constraints
model.addConstr(8 * x1 + 3 * x2 >= 25, name="vitamin_A")
model.addConstr(3 * x1 + 6 * x2 >= 25, name="vitamin_B")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Carrot juice: {x1.varValue}")
    print(f"Lemon juice: {x2.varValue}")
    print(f"Total cost: {model.objVal}")
else:
    print("No optimal solution found.")
