
import gurobipy as gp

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
x1 = m.addVar(lb=0, name="mushrooms")  # Acres of mushrooms
x2 = m.addVar(lb=0, name="truffles")  # Acres of truffles


# Set objective function
m.setObjective(200*x1 + 500*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 90, "land")
m.addConstr(80*x1 + 200*x2 <= 13500, "maintenance")
m.addConstr(2*x1 + 3*x2 <= 120, "care_time")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Acres of Mushrooms: {x1.x}")
    print(f"Acres of Truffles: {x2.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

