
from gurobipy import *

# Create a new model
m = Model("Farm_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="acres_of_mushrooms")
x2 = m.addVar(lb=0, name="acres_of_truffles")

# Set the objective function
m.setObjective(200*x1 + 500*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(80*x1 + 200*x2 <= 13500, "maintenance_cost")
m.addConstr(2*x1 + 3*x2 <= 120, "care_time")
m.addConstr(x1 + x2 <= 90, "total_land")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acres of Mushrooms: {x1.x}")
    print(f"Acres of Truffles: {x2.x}")
    print(f"Maximum Profit: ${200*x1.x + 500*x2.x:.2f}")
else:
    print("No optimal solution found")
