
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="mushrooms")
    x2 = model.addVar(lb=0, name="truffles")

    # Objective function
    model.setObjective(200*x1 + 500*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 + x2 <= 90, name="land_constraint")
    model.addConstr(80*x1 + 200*x2 <= 13500, name="maintenance_constraint")
    model.addConstr(2*x1 + 3*x2 <= 120, name="care_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Acres of mushrooms: {x1.varValue}")
        print(f"Acres of truffles: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
