
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("exam_optimization")

# Create variables
easy_questions = m.addVar(vtype=GRB.INTEGER, name="easy_questions")
hard_questions = m.addVar(vtype=GRB.INTEGER, name="hard_questions")

# Set objective function
m.setObjective(4 * easy_questions + 10 * hard_questions, GRB.MAXIMIZE)

# Add constraints
m.addConstr(easy_questions >= 4, "min_easy")
m.addConstr(hard_questions >= 2, "min_hard")
m.addConstr(easy_questions <= 12, "max_easy")
m.addConstr(hard_questions <= 4, "max_hard")
m.addConstr(easy_questions + hard_questions <= 9, "total_questions")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {m.objVal} points")
    print(f"Number of easy questions: {easy_questions.x}")
    print(f"Number of hard questions: {hard_questions.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

