
from gurobipy import *

# Create a new model
m = Model("Exam_Questions")

# Add variables
x1 = m.addVar(vtype=GRB.INTEGER, name="easy_questions")
x2 = m.addVar(vtype=GRB.INTEGER, name="hard_questions")

# Set the objective function
m.setObjective(4*x1 + 10*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 4, "at_least_4_easy")
m.addConstr(x2 >= 2, "at_least_2_hard")
m.addConstr(x1 <= 12, "at_most_12_easy")
m.addConstr(x2 <= 4, "at_most_4_hard")
m.addConstr(x1 + x2 <= 9, "total_questions")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Easy questions: {x1.x}")
    print(f"Hard questions: {x2.x}")
else:
    print("No optimal solution found")
