
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=4, ub=12, name="easy_questions")  # At least 4, at most 12 easy questions
x2 = model.addVar(lb=2, ub=4, name="hard_questions")   # At least 2, at most 4 hard questions

# Objective function: maximize 4x1 + 10x2
model.setObjective(4 * x1 + 10 * x2, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + x2 <= 9, name="total_questions")  # At most 9 questions

# Update model
model.update()

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution:")
    print(f"Easy questions: {x1.varValue}")
    print(f"Hard questions: {x2.varValue}")
    print(f"Max points: {4 * x1.varValue + 10 * x2.varValue}")
else:
    print("No optimal solution found")
