
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("investment_optimization")

# Create variables
gpus = m.addVar(vtype=GRB.CONTINUOUS, name="GPUs")
cpus = m.addVar(vtype=GRB.CONTINUOUS, name="CPUs")
software = m.addVar(vtype=GRB.CONTINUOUS, name="Software")
mobile = m.addVar(vtype=GRB.CONTINUOUS, name="Mobile")

# Set objective function
m.setObjective(0.04 * gpus + 0.06 * cpus + 0.11 * software + 0.08 * mobile, GRB.MAXIMIZE)

# Add constraints
m.addConstr(gpus + cpus + software + mobile <= 2000000, "Total_investment")
m.addConstr(gpus <= cpus, "GPUs_vs_CPUs")
m.addConstr(mobile <= software, "Mobile_vs_Software")
m.addConstr(gpus <= 0.09 * 2000000, "GPUs_limit")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal return: ${m.objVal:.2f}")
    print(f"Invest in GPUs: ${gpus.x:.2f}")
    print(f"Invest in CPUs: ${cpus.x:.2f}")
    print(f"Invest in Software: ${software.x:.2f}")
    print(f"Invest in Mobile: ${mobile.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

