
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='GPUs', lb=0)
    x2 = model.addVar(name='CPUs', lb=0)
    x3 = model.addVar(name='software', lb=0)
    x4 = model.addVar(name='mobile devices', lb=0)

    # Define the objective function
    model.setObjective(0.04 * x1 + 0.06 * x2 + 0.11 * x3 + 0.08 * x4, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 <= x2)
    model.addConstr(x4 <= x3)
    model.addConstr(x1 <= 0.09 * 2000000)
    model.addConstr(x1 + x2 + x3 + x4 <= 2000000)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal investment:')
        print(f'GPUs: {x1.varValue}')
        print(f'CPUs: {x2.varValue}')
        print(f'software: {x3.varValue}')
        print(f'mobile devices: {x4.varValue}')
        print(f'Optimal return: {model.objVal}')
    else:
        print('No optimal solution found')

solve_investment_problem()
